DROP PROCEDURE [hips].[SexCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:	  13 Nov 2013	
-- Description:   Gets a list or specific record from the linkage of the Sex Code Table
-- Modified:
-- 12/12/2013 - Simon Biber - Add code override functionality
-- =============================================
CREATE PROCEDURE [hips].[SexCodeGet] 
(
	@CodeSystemCode VARCHAR(20),
	@SexId INT = NULL
)
AS
BEGIN

	SELECT  sx.SexId, COALESCE(sc.CodeOverride, sx.Code) AS Code, sx.Description
	FROM    hips.SexCode sc
			JOIN hips.Sex sx ON sc.SexId = sx.SexId
			JOIN hips.CodeSystem cs ON sc.CodeSystemId = cs.CodeSystemId
			WHERE cs.Code = @CodeSystemCode
			AND (sx.SexId = @SexId OR @SexId IS NULL)
	ORDER BY sx.Description

END
GO

